"""FastAPI 应用入口。"""

from __future__ import annotations

from pathlib import Path
from typing import Optional

from fastapi import FastAPI
from fastapi.staticfiles import StaticFiles

from lacopro.memory.store import Database

from lacopro.agent.events import EventQueue

from .routers import alerts, commands, dashboard


def create_app(
    *,
    database: Optional[Database] = None,
    event_queue: Optional[EventQueue] = None,
) -> FastAPI:
    app = FastAPI(title="LacoPro API")
    if database is not None:
        app.state.database = database
    if event_queue is not None:
        app.state.event_queue = event_queue
    app.include_router(alerts, prefix="/api")
    app.include_router(commands, prefix="/api")
    app.include_router(dashboard, prefix="/api")

    static_root = Path(__file__).resolve().parent.parent / "static"
    dashboard_dir = static_root / "dashboard"
    if dashboard_dir.exists():
        app.mount(
            "/dashboard",
            StaticFiles(directory=dashboard_dir, html=True),
            name="dashboard",
        )
    return app


app = create_app()


__all__ = ["create_app", "app"]
