export const GAME_CONFIG = {
    // 游戏画布设置
    WIDTH: 800,
    HEIGHT: 800,
    BACKGROUND_COLOR: '#1a1a2e',
    
    // 像素艺术设置
    PIXEL_SCALE: 4,
    TILE_SIZE: 16,
    
    // 物理设置
    GRAVITY: 0,
    PLAYER_SPEED: 200,
    ENEMY_SPEED: 150,
    BULLET_SPEED: 400,
    
    // 游戏平衡
    PLAYER_LIVES: 5,  // 增加生命数，降低难度
    INVINCIBILITY_TIME: 3000, // 增加无敌时间（毫秒）
    
    // 关卡设置
    TOTAL_LEVELS: 3,
    COLLECTIBLES_PER_LEVEL: 5,  // 减少收集品数量，降低第一关难度
    
    // 音效设置
    SOUND_VOLUME: 0.7,
    MUSIC_VOLUME: 0.4,
    
    // 移动端适配
    MOBILE_SCALE: 0.8,
    TOUCH_DEADZONE: 30
} as const;

export const COLORS = {
    PLAYER: '#4a90e2',
    ENEMY: '#e74c3c',
    COLLECTIBLE: '#f39c12',
    WALL: '#34495e',
    EXIT: '#27ae60',
    TRAP: '#8e44ad',
    TEXT: '#ecf0f1',
    BACKGROUND: '#2c3e50'
} as const;

export const DIFFICULTY_SETTINGS = {
    EASY: {
        enemyCount: 1,      // 第一关只有1个敌人
        enemySpeed: 80,     // 大幅降低敌人速度
        trapCount: 0,       // 第一关没有陷阱
        powerUpChance: 0.5  // 增加道具掉落率
    },
    MEDIUM: {
        enemyCount: 3,      // 中等难度减少到3个敌人
        enemySpeed: 120,    // 降低敌人速度
        trapCount: 2,       // 减少陷阱数量
        powerUpChance: 0.3
    },
    HARD: {
        enemyCount: 5,      // 高难度减少到5个敌人
        enemySpeed: 150,    // 降低敌人速度
        trapCount: 5,       // 减少陷阱数量
        powerUpChance: 0.2
    }
} as const;