from sqlalchemy import create_engine, Column, Integer, String, Float, DateTime, Text, Boolean
from sqlalchemy.ext.declarative import declarative_base
from sqlalchemy.orm import sessionmaker
from datetime import datetime
import json

Base = declarative_base()

class Message(Base):
    __tablename__ = "messages"
    
    id = Column(Integer, primary_key=True, index=True)
    agent_name = Column(String, index=True)
    agent_role = Column(String, index=True)
    content = Column(Text)
    message_type = Column(String)  # daily, interruption, response, meeting
    context_data = Column(Text)  # JSON格式的上下文数据
    interest_score = Column(Float)
    timestamp = Column(DateTime, default=datetime.utcnow)

class MarketData(Base):
    __tablename__ = "market_data"
    
    id = Column(Integer, primary_key=True, index=True)
    timestamp = Column(DateTime, default=datetime.utcnow)
    btc_price = Column(Float)
    eth_price = Column(Float)
    btc_change_24h = Column(Float)
    eth_change_24h = Column(Float)
    volume_data = Column(Text)  # JSON格式

class NewsData(Base):
    __tablename__ = "news_data"
    
    id = Column(Integer, primary_key=True, index=True)
    timestamp = Column(DateTime, default=datetime.utcnow)
    title = Column(String)
    description = Column(Text)
    source = Column(String)
    sentiment_score = Column(Float)
    relevance_score = Column(Float)

class OfficeState(Base):
    __tablename__ = "office_state"
    
    id = Column(Integer, primary_key=True, index=True)
    timestamp = Column(DateTime, default=datetime.utcnow)
    current_topic = Column(String)
    discussion_heat = Column(Float, default=0.0)
    consensus_level = Column(Float, default=0.0)
    urgency_level = Column(Float, default=0.0)
    emotional_climate = Column(String, default="neutral")
    active_speakers = Column(Text)  # JSON array of recently active agents
    pending_topics = Column(Text)  # JSON array of topics waiting discussion

class AgentState(Base):
    __tablename__ = "agent_states"
    
    id = Column(Integer, primary_key=True, index=True)
    agent_name = Column(String, index=True)
    timestamp = Column(DateTime, default=datetime.utcnow)
    confidence_level = Column(Float, default=0.7)
    assertiveness = Column(Float, default=0.6)
    collaboration_mood = Column(Float, default=0.8)
    stress_level = Column(Float, default=0.2)
    recent_interactions = Column(Text)  # JSON格式的最近交互记录
    expertise_activation = Column(Text)  # JSON格式的专业领域激活状态

# 数据库初始化
engine = create_engine("sqlite:///./ai_office.db", echo=False)
SessionLocal = sessionmaker(autocommit=False, autoflush=False, bind=engine)

def init_database():
    Base.metadata.create_all(bind=engine)

def get_db():
    db = SessionLocal()
    try:
        yield db
    finally:
        db.close()