# 复古像素冒险游戏 - Phaser3

一个基于Phaser3引擎开发的2D复古像素风格冒险游戏，融合了吃豆人的收集元素和坦克大战的战斗机制。

## 🎮 游戏特色

- **复古像素艺术风格**: 8位像素美术，怀旧游戏体验
- **三关卡设计**: 难度递增的关卡系统
- **智能AI敌人**: 参考吃豆人设计的多种敌人行为模式
- **丰富陷阱系统**: 5种不同类型的陷阱机制
- **移动端适配**: 支持触摸控制，完美适配移动设备
- **动态音效**: 8位风格音效和背景音乐
- **完整UI系统**: 实时更新的游戏界面和反馈系统

## 🎯 游戏玩法

1. **移动控制**: 使用WASD或方向键控制角色移动
2. **收集宝物**: 收集关卡中的所有宝物以激活出口
3. **躲避敌人**: 避开具有不同AI行为的敌人
4. **避开陷阱**: 小心各种陷阱造成的伤害和效果
5. **到达出口**: 收集完所有宝物后进入出口完成关卡

## 🏗️ 项目结构

```
phaser-adventure-game/
├── src/
│   ├── config/
│   │   └── GameConfig.ts          # 游戏配置和常量
│   ├── scenes/
│   │   ├── MenuScene.ts           # 主菜单场景
│   │   ├── GameScene.ts           # 游戏主场景
│   │   └── GameOverScene.ts       # 游戏结束场景
│   ├── objects/
│   │   ├── Player.ts              # 玩家角色类
│   │   ├── Enemy.ts               # 敌人类（多种AI行为）
│   │   ├── Collectible.ts         # 收集品类
│   │   ├── Exit.ts                # 出口传送门类
│   │   └── Trap.ts                # 陷阱类（多种效果）
│   ├── managers/
│   │   ├── LevelManager.ts        # 关卡管理器
│   │   ├── UIManager.ts           # UI界面管理器
│   │   └── AudioManager.ts        # 音频管理器
│   └── utils/
│       └── Helpers.ts             # 工具函数
├── assets/
│   ├── sprites/                   # 精灵图资源
│   ├── audio/                     # 音效和音乐
│   └── ui/                        # UI资源
├── public/                        # 公共资源
├── index.html                     # 主页面
├── package.json                   # 项目依赖
├── tsconfig.json                  # TypeScript配置
└── vite.config.ts                 # Vite构建配置
```

## 🚀 快速开始

### 环境要求
- Node.js 16+ 
- npm 或 yarn

### 安装依赖
```bash
npm install
```

### 开发模式
```bash
npm run dev
```
访问 http://localhost:3000 查看游戏

### 生产构建
```bash
npm run build
```

## 🎨 美术资源生成

### 像素艺术工具推荐
- **Piskel**: https://www.piskelapp.com/ (免费在线工具)
- **Aseprite**: https://www.aseprite.org/ (专业像素艺术软件)
- **PixelLab AI**: https://www.pixellab.ai/ (AI辅助生成)

### 资源规格
- 角色精灵: 16x16 或 32x32 像素
- 颜色调色板: 8位复古色彩
- 文件格式: PNG (支持透明背景)

## 🎵 音效资源

### 音效生成工具
- **jsfxr**: https://sfxr.me/ (在线8位音效生成器)
- **Bfxr**: http://www.bfxr.net/ (音效生成工具)
- **FamiStudio**: NES风格音乐制作软件

### 音效类型
- 移动音效
- 攻击音效
- 收集音效
- 受伤音效
- 环境音效

## 🎮 技术特性

### 核心引擎
- **Phaser 3.80.1**: 最新稳定版本
- **TypeScript**: 类型安全的开发体验
- **Vite**: 现代化的构建工具

### 游戏系统
- **物理引擎**: Arcade物理系统
- **碰撞检测**: 精确的像素级碰撞
- **AI系统**: 基于吃豆人的敌人AI
- **粒子系统**: 丰富的视觉效果
- **动画系统**: 流畅的精灵动画

### 移动端优化
- **触摸控制**: 支持虚拟摇杆和手势
- **响应式布局**: 适配各种屏幕尺寸
- **性能优化**: 针对移动设备的性能调优

## 🎯 游戏机制详解

### 敌人AI系统
1. **追踪型**: 直接追击玩家
2. **伏击型**: 预测玩家路径进行拦截
3. **随机型**: 随机移动，偶尔追击
4. **Boss型**: 结合多种行为模式

### 陷阱系统
1. **尖刺陷阱**: 造成直接伤害
2. **激光陷阱**: 持续伤害
3. **毒雾陷阱**: 持续伤害+减速
4. **减速陷阱**: 降低移动速度
5. **眩晕陷阱**: 短暂无法移动

### 关卡设计
- **第1关**: 简单迷宫，2个敌人，教学导向
- **第2关**: 复杂迷宫，4个敌人，加入陷阱
- **第3关**: 大型迷宫，6个敌人+Boss，最终挑战

## 🛠️ 开发指南

### 添加新关卡
1. 在`LevelManager.ts`中添加新的关卡数据
2. 定义墙壁、敌人、收集品的位置
3. 设置关卡难度和特殊规则

### 自定义敌人行为
1. 在`Enemy.ts`中创建新的行为类
2. 实现`EnemyBehavior`接口
3. 在敌人构造函数中指定行为类型

### 添加新陷阱类型
1. 在`Trap.ts`中创建新的效果类
2. 实现`TrapEffect`接口
3. 在陷阱构造函数中指定效果类型

## 🔧 配置选项

### 游戏配置 (`GameConfig.ts`)
```typescript
GAME_CONFIG = {
    WIDTH: 800,                    // 游戏宽度
    HEIGHT: 800,                   // 游戏高度
    PLAYER_SPEED: 200,             // 玩家移动速度
    ENEMY_SPEED: 150,              // 敌人移动速度
    PLAYER_LIVES: 3,               // 玩家生命数
    TOTAL_LEVELS: 3,               // 总关卡数
    SOUND_VOLUME: 0.7,             // 音效音量
    MUSIC_VOLUME: 0.4              // 音乐音量
}
```

### 难度设置 (`DIFFICULTY_SETTINGS`)
- **EASY**: 2个敌人，低速，更多道具
- **MEDIUM**: 4个敌人，中速，平衡道具
- **HARD**: 6个敌人，高速，较少道具

## 🎨 自定义主题

### 颜色配置 (`COLORS`)
可以自定义游戏中的主要颜色：
- 玩家颜色
- 敌人颜色
- 收集品颜色
- UI元素颜色

### 像素缩放
调整`PIXEL_SCALE`改变像素艺术的显示大小

## 📱 移动端适配

### 触摸控制
- 屏幕左半部分控制移动
- 屏幕右半部分控制攻击
- 支持多点触控

### 响应式设计
- 自动适配屏幕尺寸
- 保持1:1的画面比例
- 优化触摸体验

## 🔊 音频系统集成

### 音效播放
```typescript
// 播放音效
audioManager.playSound('collect');

// 播放随机音高
audioManager.playRandomPitch('attack', 0.2);

// 播放序列音效
audioManager.playSequentialSounds(['sound1', 'sound2', 'sound3'], 100);
```

### 背景音乐
```typescript
// 播放关卡音乐
audioManager.playLevelMusic(1);

// 播放Boss音乐
audioManager.playBossMusic();

// 播放胜利音乐
audioManager.playVictoryMusic();
```

## 🎮 扩展功能建议

### 可添加的功能
- **道具系统**: 加速、无敌、攻击增强等
- **技能系统**: 玩家可以学习和升级技能
- **成就系统**: 完成特定任务获得成就
- **排行榜**: 记录玩家高分
- **多人模式**: 支持本地或在线多人游戏
- **关卡编辑器**: 允许玩家创建自定义关卡

### 性能优化
- **对象池**: 重用游戏对象减少内存分配
- **视锥剔除**: 只渲染可见区域内的对象
- **纹理图集**: 合并小纹理减少绘制调用
- **音频压缩**: 优化音频文件大小

## 🐛 常见问题

### Q: 游戏在移动设备上运行缓慢？
A: 检查以下几点：
- 减少同时显示的粒子数量
- 优化碰撞检测频率
- 使用对象池管理频繁创建的对象
- 降低渲染分辨率

### Q: 音效无法播放？
A: 可能的原因：
- 浏览器音频自动播放限制
- 音频文件路径错误
- 音频格式不支持
- 音频上下文被阻止

### Q: 精灵显示模糊？
A: 确保配置：
- `pixelArt: true`
- `antialias: false`
- `roundPixels: true`

## 📄 许可证

MIT License - 详见 LICENSE 文件

## 🤝 贡献

欢迎提交Issue和Pull Request来改进这个项目！

## 📞 联系方式

如有问题或建议，请通过以下方式联系：
- 提交GitHub Issue
- 发送邮件至项目维护者

---

**享受游戏开发，创造精彩的像素冒险世界！** 🎮✨