// SPDX-License-Identifier: MIT
pragma solidity ^0.8.20;

import "@openzeppelin/contracts/token/ERC20/ERC20.sol";
import "@openzeppelin/contracts/access/Ownable.sol";

/**
 * @title MockAGToken
 * @dev Mock AG Token for testing purposes only
 * This will be replaced with the actual AG token from four.meme platform
 */
contract MockAGToken is ERC20, Ownable {
    uint256 public constant TOTAL_SUPPLY = 1_000_000_000 * 10**18; // 1 billion tokens
    
    constructor() ERC20("JuxGame Token", "AG") {
        _mint(msg.sender, TOTAL_SUPPLY);
    }
    
    /**
     * @dev Mint tokens for testing (owner only)
     */
    function mint(address to, uint256 amount) external onlyOwner {
        _mint(to, amount);
    }
    
    /**
     * @dev Faucet function for testing - gives 1M AG tokens to caller
     */
    function faucet() external {
        require(balanceOf(msg.sender) < 1_000_000 * 10**18, "Already received faucet");
        _mint(msg.sender, 1_000_000 * 10**18); // 1M AG tokens
    }
}