# ABattle 系统总体规划

**目标**：打造一个覆盖 A 股数据、模拟交易引擎与多 Agent 投资竞技的综合平台，让不同 LLM 驱动的策略在统一沙盒中自主决策、交易与反思。

---

## 一、系统蓝图

- **市场数据层**：以 Tushare 为核心，构建可扩展的数据服务，覆盖行情、估值、资金、事件等维度，支持缓存、校验与回放。
- **模拟交易引擎**：支持多账户、多策略的虚拟交易，涵盖订单撮合、风控、收益统计与结算。
- **多 Agent 调度**：驱动多个 LLM Agent，提供统一工具调用接口、记忆与反思机制，按交易节奏定时运行。
- **监控与前端**：可视化净值、持仓、回合记录，保证过程可追溯、可观测。

---

## 二、数据服务规划

### 2.1 数据主题

| 模块 | 内容 | 说明 |
| --- | --- | --- |
| 行情 | 日/分钟 K 线、指数、涨跌停、停牌、成交额 | 支持增量更新与回放 |
| 估值 | PE/PB/市值、财务指标、盈利预测 | 整合 `daily_basic`、`fina_indicator` 等接口 |
| 资金 | 主力资金流向、北向资金、融资融券 | 频繁更新，需缓存 |
| 事件 | 公告、新闻、互动易、集合竞价 | 需单独权限，作为高级工具 |
| 基本信息 | 股票列表、行业分类、股本变动 | 启动时加载、定期刷新 |

### 2.2 技术要点

- 构建 `tushare_toolkit`：封装接口调度、限频控制、数据清洗；提供统一 JSON Schema。
- 缓存策略：Redis (热点查询)，PostgreSQL (历史数据)；定期进行完整性校验。
- 借鉴项目：`QUANTAXIS` 的数据抓取与存储结构、`rqalpha` 的数据 bundle 设计。

---

## 三、模拟交易引擎

### 3.1 核心组件

1. **账户体系**：
   - `accounts`（项目全局账户信息）、`strategy_accounts`（每个 Agent 独立账户）。
   - 记录现金、可用资金、冻结资金、持仓成本、浮盈亏。
2. **订单撮合**：
   - 市价/限价订单，支持部分成交、撤单；
   - 撮合基于最新行情或模拟 VWAP；
   - 风控：资金校验、持仓限制、涨跌停、停牌检查。
3. **结算**：
   - 日度估值、NAV 计算、手续费与印花税、T+1 控制。
4. **指标统计**：
   - 当日收益、累计收益、年化、最大回撤、换手率，写入 `performance_metrics`。

### 3.2 架构参考

- `ricequant/rqalpha` 的事件驱动与撮合模块。
- `vnpy` PortfolioEngine 的仓位和风险管理。
- 数据库存储：PostgreSQL 表 (`orders`, `trades`, `positions`, `cash_flows`, `daily_nav`)；所有操作日志化。

---

## 四、多 Agent 系统

### 4.1 Agent 类型

- **策略 Agent**：不同 LLM 与 Prompt 设定，负责实盘决策。
- **市场播报 Agent**：汇总行情、热点、宏观数据，供其他 Agent 使用。
- **风险审计 Agent**：对策略建议进行风险检查，给出反馈。
- **复盘 Agent**：每回合总结表现，写入记忆库。

### 4.2 工具接口

- `market_tool`: 获取最新行情/资金指标。
- `account_tool`: 查询账户、持仓、历史收益。
- `order_tool`: 提交订单、验证规则。
- `analytics_tool`: 计算因子、动量、行业概览。
- `news_tool`: 获取公告、资讯摘要。

### 4.3 记忆与反思

- 短期记忆：回合上下文 + 最近指令。
- 中期记忆：账户表现、策略摘要。
- 长期记忆：复盘 Agent 汇总、策略风格演化。
- 参考 `microsoft/autogen`、`LangGraph` 架构，实现聊天式反思与 JSON 协议输出。

---

## 五、调度与运行

1. **交易日历**：引用 Tushare `trade_cal` 判定开市；节假日自动暂停。
2. **盘前任务 (开盘前 20 分钟)**：刷新数据、同步账户、清理订单。
3. **盘中回合 (每 20 分钟)**：
   - 收集行情 → 广播上下文 → Agent 决策 → 风控执行 → 记录结果。
4. **收盘任务**：结算 NAV、生成日报、同步长记忆。
5. **调度工具**：APScheduler 或 Celery + Redis；后续可升级为消息队列（RabbitMQ/Kafka）。

---

## 六、监控与前端

- 扩展现有前端，增加：
  - 多账户净值曲线、收益对比；
  - 当日交易流水、持仓结构；
  - Agent 回合日志、Prompt/响应可视化；
  - 数据接口调用情况、延迟、失败率；
  - 风险指标、告警列表。
- 日志：结构化 JSON，考虑接入 Elastic/Loki；保证审计与复盘可追溯。

---

## 七、风险与质量控制

- **容错策略**：Tushare 失败时 fallback 缓存，LLM 超时 fallback 次级模型或保持持仓。
- **验证**：订单提交前多重校验；结果存档后可回放。
- **测试**：单元测试覆盖数据清洗、撮合、风险控制；模拟多 Agent 并发场景。
- **安全**：限制工具接口，防止 LLM 发送危险指令；所有外部请求有白名单与速率限制。

---

## 八、阶段划分（概览）

1. **基础设施搭建**：项目结构、数据库、依赖、配置管理。
2. **数据服务增强**：工具箱完善、缓存/校验机制、数据字典。
3. **交易引擎原型**：账户、撮合、风控、结算、指标输出。
4. **Agent 框架 PoC**：单 Agent + 工具调用 + JSON 指令解析。
5. **多 Agent 协作**：增加风险审计/复盘 Agent，完善记忆系统。
6. **调度与监控**：盘前/盘中/收盘任务，前端可视化与日志监控。
7. **扩展与优化**：加入高级数据、记忆策略、性能调优、回放模式。

---

# 附录：参考项目清单

- 模拟交易：`ricequant/rqalpha`、`QUANTAXIS/QUANTAXIS`、`vnpy/vnpy`
- Agent 与评估：`microsoft/autogen`、`LangChain LangGraph`、`harrypapa2002/StockSim`、`battlecapital/FinRobot`
- 数据工具：`xingetouzi/rqalpha-mod-fxdayu-source`、`alanyoungcy/tradingtools`

